IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_EST_PROD_CPL_LOTE]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [DBO].[P_EST_PROD_CPL_LOTE]

GO

CREATE PROCEDURE P_EST_PROD_CPL_LOTE AS
BEGIN


    DECLARE @CD_EMP INT
    DECLARE @CD_FILIAL INT
    DECLARE @CD_PROD INT
    DECLARE @NR_LOTE NVARCHAR(100)
    DECLARE @CD_LOTE INT
    DECLARE @CD_LOTE_SNGPC INT
    DECLARE @QTDE_LOTE MONEY
  
    CREATE TABLE #RSLOTES_NOVOS
    (
	   CD_EMP INT
	   ,CD_FILIAL INT
	   ,CD_LOTE_SNGPC INT
	   ,CD_PROD INT
	   ,NR_LOTE NVARCHAR(100)
	   ,DT_VALID DATETIME
	   ,QTDE_PROD MONEY
	   ,DT_FABRIC INT
	   ,DT_FABR SMALLDATETIME
	   ,DT_CAD DATETIME
	   ,CD_AGREGADOR VARCHAR(100)
    )

  CREATE TABLE #RSLOTES_QUANTIDADE_DIFERENTE
    (
	   CD_EMP INT
	   ,CD_FILIAL INT
	   ,CD_LOTE INT
	   ,CD_LOTE_SNGPC INT
	   ,CD_PROD INT
	   ,NR_LOTE NVARCHAR(100)
	   ,DT_VALID DATETIME
	   ,QTDE_PROD MONEY
	   ,DT_FABRIC INT
	   ,DT_FABR SMALLDATETIME
	   ,DT_CAD DATETIME
	   ,CD_AGREGADOR VARCHAR(100)
    )

  
    --PEGANDO TODOS OS LOTES PENDENTES DE PROCESSAMENTO
    INSERT INTO #RSLOTES_NOVOS
    SELECT 
	   L.CD_EMP
	   ,LF.CD_FILIAL
	   ,L.CD_LOTE
	   ,L.CD_PROD
	   ,L.NR_LOTE
	   ,L.VALIDADE
	   ,LF.QT_LOTE
	   ,0 AS DT_FABRIC
	   ,CAST(GETDATE() AS SMALLDATETIME) AS DT_FABRICACAO
	   ,GETDATE() AS DT_CAD
	   ,NULL AS CD_AGREGADOR
	FROM 
	   EST_PROD_EST_SNGPC_LOTE L INNER JOIN EST_PROD_EST_SNGPC_LOTE_CPL LF ON
	   L.CD_EMP=LF.CD_EMP AND
	   L.CD_LOTE=LF.CD_LOTE
    
    WHERE 
	   LF.QT_LOTE>0 AND
	   LF.PEND_VALID=0
    
    --PREAPARANDO LOTES COM QUANTIDADE DIVERGENTE DE LOTES ENTRE GESTO E SNGPC
    INSERT INTO #RSLOTES_QUANTIDADE_DIFERENTE SELECT 
												L.CD_EMP 
												,L.CD_FILIAL 
												,LT.CD_LOTE
												,L.CD_LOTE_SNGPC
												,L.CD_PROD 
												,L.NR_LOTE 
												,L.DT_VALID 
												,L.QTDE_PROD 
												,L.DT_FABRIC 
												,L.DT_FABR 
												,L.DT_CAD 
												,L.CD_AGREGADOR 
											FROM 
												#RSLOTES_NOVOS L INNER JOIN EST_PROD_CPL_LOTE  LT  ON
												L.CD_EMP=LT.CD_EMP AND
											    L.CD_FILIAL=LT.CD_FILIAL AND
											    L.CD_PROD=LT.CD_PROD AND
											    L.NR_LOTE=LT.NR_LOTE 

										    WHERE 
											    L.QTDE_PROD<>LT.QTDE_PROD

    --REMOVENDO LOTES QUE JA EXISTEM NO GESTO
    DELETE FROM #RSLOTES_NOVOS  WHERE  EXISTS (SELECT 
													   LT.CD_EMP 
												   FROM 
													   EST_PROD_CPL_LOTE  LT 
												   WHERE  
													   #RSLOTES_NOVOS.CD_EMP=LT.CD_EMP AND
													   #RSLOTES_NOVOS.CD_FILIAL=LT.CD_FILIAL AND
													   #RSLOTES_NOVOS.CD_PROD=LT.CD_PROD AND
													   #RSLOTES_NOVOS.NR_LOTE=LT.NR_LOTE)

    


    --INSERINDO LOTES NOVOS
    DECLARE CURSOR_LOTES_SNGPC_GESTAO 
    CURSOR FOR   SELECT DISTINCT CD_EMP,CD_FILIAL, CD_PROD,NR_LOTE,CD_LOTE_SNGPC FROM #RSLOTES_NOVOS

    OPEN CURSOR_LOTES_SNGPC_GESTAO

    FETCH NEXT FROM CURSOR_LOTES_SNGPC_GESTAO INTO @CD_EMP,@CD_FILIAL,@CD_PROD,@NR_LOTE,@CD_LOTE_SNGPC

    WHILE @@FETCH_STATUS = 0
    BEGIN
	   SET @CD_LOTE=0;
	   SET @CD_LOTE= (SELECT ISNULL(MAX(CD_LOTE),0) + 1 FROM EST_PROD_CPL_LOTE WHERE CD_EMP=@CD_EMP AND CD_FILIAL=@CD_FILIAL);
	   
		  INSERT INTO EST_PROD_CPL_LOTE (CD_EMP, CD_FILIAL, CD_LOTE, CD_PROD, NR_LOTE, DT_VALID, 
										 QTDE_PROD, DT_FABRIC, DT_FABR, DT_CAD, CD_AGREGADOR, CD_USU , CD_USU_ALT , DT_ALT )
		  SELECT
			 CD_EMP
			 ,CD_FILIAL
			 ,@CD_LOTE
			 ,CD_PROD
			 ,NR_LOTE
			 ,DT_VALID
			 ,QTDE_PROD
			 ,DT_FABRIC
			 ,DT_FABR
			 ,DT_CAD
			 ,CD_AGREGADOR
			 , 1 
			 , 1
			 , GETDATE()
		  FROM
			 #RSLOTES_NOVOS
		  WHERE
			 CD_EMP=@CD_EMP AND CD_FILIAL=@CD_FILIAL AND NR_LOTE=@NR_LOTE;

		  UPDATE EST_PROD_EST_SNGPC_LOTE_CPL SET PEND_VALID=1 WHERE CD_EMP=@CD_EMP AND CD_FILIAL=@CD_FILIAL AND CD_LOTE=@CD_LOTE_SNGPC;

		  FETCH NEXT FROM CURSOR_LOTES_SNGPC_GESTAO INTO @CD_EMP,@CD_FILIAL,@CD_PROD,@NR_LOTE,@CD_LOTE_SNGPC
    END

    CLOSE CURSOR_LOTES_SNGPC_GESTAO;
    DEALLOCATE CURSOR_LOTES_SNGPC_GESTAO;


    --EQUALIZANDO ESTOQUES DOS LOTES ENTRE SNGPC E GESTAO
    DECLARE CURSOR_LOTES_SNGPC_EQUALIZAR 
    CURSOR FOR   SELECT DISTINCT CD_EMP,CD_FILIAL, CD_LOTE,CD_LOTE_SNGPC,QTDE_PROD FROM #RSLOTES_QUANTIDADE_DIFERENTE

    OPEN CURSOR_LOTES_SNGPC_EQUALIZAR

    FETCH NEXT FROM CURSOR_LOTES_SNGPC_EQUALIZAR INTO @CD_EMP,@CD_FILIAL,@CD_LOTE,@CD_LOTE_SNGPC,@QTDE_LOTE

    WHILE @@FETCH_STATUS = 0
    BEGIN
	   
		  UPDATE 
			 EST_PROD_CPL_LOTE
		  SET
			 QTDE_PROD=@QTDE_LOTE
		  WHERE
			 CD_EMP=@CD_EMP AND CD_FILIAL=@CD_FILIAL AND CD_LOTE=@CD_LOTE;

		  UPDATE EST_PROD_EST_SNGPC_LOTE_CPL SET PEND_VALID=1 WHERE CD_EMP=@CD_EMP AND CD_FILIAL=@CD_FILIAL AND CD_LOTE=@CD_LOTE_SNGPC;

		  FETCH NEXT FROM CURSOR_LOTES_SNGPC_EQUALIZAR INTO @CD_EMP,@CD_FILIAL,@CD_LOTE,@CD_LOTE_SNGPC,@QTDE_LOTE
    END

    CLOSE CURSOR_LOTES_SNGPC_EQUALIZAR;
    DEALLOCATE CURSOR_LOTES_SNGPC_EQUALIZAR;

    DROP TABLE #RSLOTES_NOVOS
    DROP TABLE #RSLOTES_QUANTIDADE_DIFERENTE

END